Public Class Form1
    Dim m_pOrigin As Origin.IOApplication
    Dim m_nRows As Integer
    Dim m_rndGet As Random
    Public Sub New()

        InitializeComponent()

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Call EnableControls(False)
    End Sub

    Private Sub EnableControls(ByVal bConnect As Boolean)
        ButtonClear.Enabled = bConnect
        ButtonDisconnect.Enabled = bConnect
        ButtonSendData.Enabled = bConnect
        ButtonClear.Enabled = bConnect
        CheckBoxAppend.Enabled = bConnect
        CheckBoxSave.Enabled = bConnect

        ButtonConnect.Enabled = Not bConnect
    End Sub

    Private Sub Disconnect()
        If Not m_pOrigin Is Nothing Then
            If CheckBoxSave.Checked Then
                If TextBoxProjectName.Text.Length > 0 Then
                    m_pOrigin.Save(TextBoxProjectName.Text)
                End If
            End If

            If CheckBoxExit.Checked Then
                m_pOrigin.Exit()
            End If
            System.Runtime.InteropServices.Marshal.ReleaseComObject(m_pOrigin)
            m_pOrigin = Nothing
            CheckBoxSave.Checked = False
            Call EnableControls(False)
        End If
    End Sub

    Private Sub Connect()
        Call Disconnect() 'in case connected
        If RadioButtonNew.Checked Then
            m_pOrigin = New Origin.Application 'new instance
        Else
            m_pOrigin = New Origin.ApplicationSI 'exising instance
        End If
        If m_pOrigin Is Nothing Then
            MsgBox("Can not access Orign instance!")
            Exit Sub
        Else
            If CheckBoxShowOrigin.Checked Then
                m_pOrigin.Visible = Origin.MAINWND_VISIBLE.MAINWND_SHOW
            Else
                m_pOrigin.Visible = Origin.MAINWND_VISIBLE.MAINWND_HIDE
            End If

            '%Y is the labtalk string register to hold the current user file folder path
            '%G is the current project file name
            TextBoxProjectName.Text = m_pOrigin.LTStr("%Y") + m_pOrigin.LTStr("%G")

            m_rndGet = New Random()
            Call EnableControls(True)
            m_nRows = 0
        End If
    End Sub

    Private Sub ClearWorksheet()
        Dim wks As Origin.Worksheet
        wks = CheckGetWorksheet()
        If wks Is Nothing Then
            MsgBox("Can not clear specified Worksheet!")
            Exit Sub
        End If
        wks.ClearData(0, -1)
    End Sub

    Private Sub SendData()
        If m_pOrigin Is Nothing Then
            Exit Sub
        End If

        If TextBoxCols.Text.Length < 1 Or TextBoxRows.Text.Length < 1 Then
            MsgBox("Please specified the number of rows and columns!")
            Exit Sub
        End If

        Dim iRows As Integer, iCols As Integer, iStartRow As Integer
        iRows = CInt(TextBoxRows.Text)
        iCols = CInt(TextBoxCols.Text)
        If iRows < 1 Or iCols < 1 Then
            MsgBox("Number of columns and rows should both bigger than 1.")
            Exit Sub
        End If
        Dim wks As Origin.Worksheet
        wks = CheckGetWorksheet()
        If wks Is Nothing Then
            MsgBox("Fail to get specified Worksheet!")
            Exit Sub
        End If
        'wks.Activate() ' if plot graph, should keep graph at the front
        'If user wants to append data, -1 should be used and it will trigger the proper realtime charting in Origin
        'support for Worksheet -1 to append requires SR5, but -1 to append in Column.SetData was supported in SR4
        If CheckBoxAppend.Checked Then
            iStartRow = -1
        Else
            m_nRows = 0
            iStartRow = m_nRows
        End If

        Dim Data(0 To iRows - 1, 0 To iCols - 1) As Double
        For iRow = 0 To iRows - 1
            Data(iRow, 0) = m_nRows + iRow
            For iCol = 1 To iCols - 1
                Data(iRow, iCol) = ((iRow + 1) * 10 + iCol) * m_rndGet.NextDouble()
            Next
        Next
        m_nRows += iRows
        wks.SetData(Data, iStartRow, 0)
    End Sub

    Private Function CheckGetWorksheet() As Origin.Worksheet
        Dim wks As Origin.Worksheet
        Dim strBookName As String, strSheetName As String
        wks = Nothing
        strBookName = TextBoxBookName.Text
        strSheetName = TextBoxSheetName.Text
        If strBookName.Length < 1 Or strSheetName.Length < 1 Then
            MsgBox("Please specify valid Book name and Sheet name!")
            Return Nothing
        End If
        'Sophy 12/10/2009 NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
        'wks = m_pOrigin.FindWorksheet("[" + strBookName + "]" + strSheetName)
        'And I found the following code can not work properly, if it fail to find layer the first time, it will create new layer _14_ instead of "14"(internally it will replace quotations with underlines
        'better first find page and then attempt to find layer.
        'If IsNumeric(strSheetName) Then
        '    strSheetName = Chr(34) & strSheetName & Chr(34)
        'End If
        'end NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
        If wks Is Nothing Then
            Dim wksPage As Origin.WorksheetPage
            wksPage = m_pOrigin.WorksheetPages.Item(strBookName)
            If wksPage Is Nothing Then
                strBookName = m_pOrigin.CreatePage(Origin.PAGETYPES.OPT_WORKSHEET, strBookName, "w", 2) '2 means visible
                wksPage = m_pOrigin.WorksheetPages.Item(strBookName)
                'Sophy 12/10/2009 NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
                'wks = wksPage.Layers.Item(strSheetName)
                'end NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
            End If

            If wks Is Nothing Then 'when worksheet is not exists, should create it
                'Sophy 12/10/2009 NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
                'wks = wksPage.Layers.Add(strSheetName)
                wks = wksPage.Layers.Item(strSheetName)
                If wks Is Nothing Then
                    wks = wksPage.Layers.Add(strSheetName)
                End If
                'end NUMERIC_SHEETNAME_SUPPORT_FORCE_CALLER_TO_ADD_QUOTATION_MARKS_TO_INDICATE_ITS_NAME_BUT_NOT_INDEX
            End If
        End If
        Return wks
    End Function

    Private Sub ButtonConnect_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonConnect.MouseClick
        Call Connect()
    End Sub

    Private Sub ButtonSendData_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonSendData.MouseClick
        Call SendData()
    End Sub

    Private Sub ButtonDisconnect_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonDisconnect.MouseClick
        Call Disconnect()
    End Sub

    Private Sub CheckBoxSave_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxSave.CheckedChanged
        TextBoxProjectName.Enabled = CheckBoxSave.Checked And CheckBoxSave.Enabled
    End Sub

    Private Sub ButtonClear_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonClear.MouseClick
        Call ClearWorksheet()
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Call Disconnect()
    End Sub

    Private Sub CheckBoxShowOrigin_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxShowOrigin.CheckedChanged
        If m_pOrigin Is Nothing Then
            Exit Sub
        End If
        If CheckBoxShowOrigin.Checked Then
            m_pOrigin.Visible = Origin.MAINWND_VISIBLE.MAINWND_SHOW
        Else
            m_pOrigin.Visible = Origin.MAINWND_VISIBLE.MAINWND_HIDE
        End If
    End Sub
End Class
